package chess4j.board;

public enum File {
	FILE_A(0,"a"),
	FILE_B(1,"b"),
	FILE_C(2,"c"),
	FILE_D(3,"d"),
	FILE_E(4,"e"),
	FILE_F(5,"f"),
	FILE_G(6,"g"),
	FILE_H(7,"h");
	
	private int _value;
	private String _label;
	
	private File(int value,String label) {
		_value=value;
		_label=label;
	}
	
	public boolean equals(File f) {
		if (f==null) return false;
		return f.getValue()==_value;
	}
	
	public int getValue() {
		return _value;
	}
	
	public String getLabel() {
		return _label;
	}

	public int distance(File f) {
		return Math.abs(f.getValue()-getValue());
	}
	
	public boolean eastOf(File f) {
		return this.getValue() > f.getValue();
	}
	
	public boolean westOf(File f) {
		return this.getValue() < f.getValue();
	}
	
	public File east() {
		if (_value==7) return null;
		return file(_value+1);
	}
	
	public File west() {
		if (_value==0) return null;
		return file(_value-1);
	}
	
	public static File file(int value) {
		for (File f : File.values()) {
			if (f.getValue()==value) {
				return f;
			}
		}
		throw new IllegalArgumentException("File value not found: " + value);
	}

	public static File file(String value) {
		for (File f : File.values()) {
			if (f.getLabel().equalsIgnoreCase(value)) {
				return f;
			}
		}
		throw new IllegalArgumentException("File value not found: " + value);
	}
	
	public static void main(String args[]) {
		for (File f : File.values()) {
			System.out.println(f + " " + f.getLabel() +
					" " + f.east() + " " + f.west());
		}
	}
}
